#=====================================================
# -*- coding: utf-8 -*-
# author : Julio - PenPower Digital Development Dept.
# Creation : 2024.09.19.
# Target Platform : Python v2.x Runtime Environment
#=====================================================

from enum import Enum
from ctypes import *
from structdefs import *

#--------------------------------------------------------------------------
# PPL501F APIs Definitions
#--------------------------------------------------------------------------
#
#==========================================================================
# PPL501F_InitialDevice(deviceID, widgetPtr, x, y, nWidth, nHeight)
#==========================================================================
def API_PPL501F_InitialDevice():
	dll = CDLL('./libppsignpadsdk.so')
	func = dll.PPL501F_InitialDevice
	func.argtypes = [c_int32, c_void_p, c_int32, c_int32, c_int32, c_int32]
	func.restype = c_bool
	return func

__PPL501F_InitialDevice = API_PPL501F_InitialDevice()

def PPL501F_InitialDevice(deviceID, widgetPtr, x, y, nWidth, nHeight):
	m_deviceID = c_int32(deviceID)
	m_pWidget = cast(widgetPtr, c_void_p)
	m_x = c_int32(x)
	m_y = c_int32(y)
	m_Width = c_int32(nWidth)
	m_Height = c_int32(nHeight)
	m_bResult = c_bool()
	m_bResult = __PPL501F_InitialDevice(m_deviceID, m_pWidget, m_x, m_y, m_Width, m_Height)
	return m_bResult
#==========================================================================
#
#==========================================================================
# PPL501F_UnInitialDevice(deviceID)
#==========================================================================
def API_PPL501F_UnInitialDevice():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL501F_UnInitialDevice
    func.argtypes = [c_int32]
    func.restype = c_int32
    return func

__PPL501F_UnInitialDevice = API_PPL501F_UnInitialDevice()

def PPL501F_UnInitialDevice(deviceID):
    m_deviceID = c_int32(deviceID)
    m_nResult = c_int32()
    m_nResult = __PPL501F_UnInitialDevice(m_deviceID)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL501F_AboutBox(widgetPtr)
#==========================================================================
def API_PPL501F_AboutBox():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL501F_AboutBox
    func.argtypes = [c_void_p]
    return func

__PPL501F_AboutBox = API_PPL501F_AboutBox()

def PPL501F_AboutBox(widgetPtr):
    m_pWidget = cast(widgetPtr, c_void_p)
    __PPL501F_AboutBox(m_pWidget)
#==========================================================================
#
#==========================================================================
# PPL501F_SetPenColor(deviceID, nR, nG, nB)
#==========================================================================
def API_PPL501F_SetPenColor():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL501F_SetPenColor
    func.argtypes = [c_int32, c_int32, c_int32, c_int32]
    func.restype = c_int32
    return func

__PPL501F_SetPenColor = API_PPL501F_SetPenColor()

def PPL501F_SetPenColor(deviceID, nR, nG, nB):
    m_deviceID = c_int32(deviceID)
    m_nR = c_int32(nR)
    m_nG = c_int32(nG)
    m_nB = c_int32(nB)
    m_nResult = c_int32()
    m_nResult = __PPL501F_SetPenColor(m_deviceID, m_nR, m_nG, m_nB)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL501F_SetPenWidth(deviceID, nWidth)
#==========================================================================
def API_PPL501F_SetPenWidth():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL501F_SetPenWidth
    func.argtypes = [c_int32, c_int32]
    func.restype = c_int32
    return func

__PPL501F_SetPenWidth = API_PPL501F_SetPenWidth()

def PPL501F_SetPenWidth(deviceID, nWidth):
    m_deviceID = c_int32(deviceID)
    m_nWidth = c_int32(nWidth)
    m_nResult = c_int32()
    m_nResult = __PPL501F_SetPenWidth(m_deviceID, m_nWidth)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL501F_SetPenStyle(deviceID, bPressureOn)
#==========================================================================
def API_PPL501F_SetPenStyle():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL501F_SetPenStyle
    func.argtypes = [c_int32, c_bool]
    func.restype = c_int32
    return func

__PPL501F_SetPenStyle = API_PPL501F_SetPenStyle()

def PPL501F_SetPenStyle(deviceID, bPressureOn):
    m_deviceID = c_int32(deviceID)
    m_bPressureOn = c_bool(bPressureOn)
    m_nResult = c_int32()
    m_nResult = __PPL501F_SetPenStyle(m_deviceID, m_bPressureOn)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL501F_Clear(deviceID)
#==========================================================================
def API_PPL501F_Clear():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL501F_Clear
    func.argtypes = [c_int32]
    func.restype = c_int32
    return func

__PPL501F_Clear = API_PPL501F_Clear()

def PPL501F_Clear(deviceID):
    m_deviceID = c_int32(deviceID)
    m_nResult = c_int32()
    m_nResult = __PPL501F_Clear(m_deviceID)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL501F_Base64Encode(deviceID, nImageTypeID)
#==========================================================================
def API_PPL501F_Base64Encode():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL501F_Base64Encode
    func.argtypes = [c_int32, c_int32]
    func.restype = POINTER(c_char)
    return func

__PPL501F_Base64Encode = API_PPL501F_Base64Encode()

def PPL501F_Base64Encode(deviceID, nImageTypeID):
    m_deviceID = c_int32(deviceID)
    m_nImageTypeID = c_int32(nImageTypeID)
    m_pChar = POINTER(c_char)
    m_pChar = __PPL501F_Base64Encode(m_deviceID, m_nImageTypeID)
    return m_pChar
#==========================================================================
#
#==========================================================================
# PPL501F_Base64EncodeFree(deviceID, pData)
#==========================================================================
def API_PPL501F_Base64EncodeFree():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL501F_Base64EncodeFree
    func.argtypes = [c_int32, c_char_p]
    func.restype = None
    return func

__PPL501F_Base64EncodeFree = API_PPL501F_Base64EncodeFree()

def PPL501F_Base64EncodeFree(deviceID, pData):
    m_deviceID = c_int32(deviceID)
    m_pData = pData
    __PPL501F_Base64EncodeFree(m_deviceID, m_pData)
#==========================================================================
#
#==========================================================================
# PPL501F_GetTotalInkPointsNumber(deviceID)
#==========================================================================
def PPL501F_GetTotalInkPointsNumber():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL501F_GetTotalInkPointsNumber
    func.argtypes = [c_int32]
    func.restype = c_int32
    return func

__PPL501F_GetTotalInkPointsNumber = PPL501F_GetTotalInkPointsNumber()

def PPL501F_GetTotalInkPointsNumber(deviceID):
    m_deviceID = c_int32(deviceID)
    m_nResult = c_int32()
    m_nResult = __PPL501F_GetTotalInkPointsNumber(m_deviceID)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL501F_Base64Decode(deviceID, nImageTypeID, encodeString, wDecodeFilePath)
#==========================================================================
def API_PPL501F_Base64Decode():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL501F_Base64Decode
    func.argtypes = [c_int32, c_int32, c_char_p, c_wchar_p]
    func.restype = c_int32
    return func

__PPL501F_Base64Decode = API_PPL501F_Base64Decode()

def PPL501F_Base64Decode(deviceID, nImageTypeID, encodeString, wDecodeFilePath):
    m_deviceID = c_int32(deviceID)
    m_nImageTypeID = c_int32(nImageTypeID)
    m_pEncodeString = c_char_p(encodeString)
    m_pwDecodeFilePath = wDecodeFilePath
    m_nResult = c_int32()
    m_nResult = __PPL501F_Base64Decode(m_deviceID, m_nImageTypeID, m_pEncodeString, m_pwDecodeFilePath)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL501F_GetDecodeInkPointData(deviceID, nIndex, nTypeID)
#==========================================================================
def API_PPL501F_GetDecodeInkPointData():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL501F_GetDecodeInkPointData
    func.argtypes = [c_int32, c_int32, c_int32]
    func.restype = c_int32
    return func

__PPL501F_GetDecodeInkPointData = API_PPL501F_GetDecodeInkPointData()

def PPL501F_GetDecodeInkPointData(deviceID, nIndex, nTypeID):
    m_deviceID = c_int32(deviceID)
    m_nIndex = c_int32(nIndex)
    m_nTypeID = c_int32(nTypeID)
    m_nResult = c_int32()
    m_nResult = __PPL501F_GetDecodeInkPointData(m_deviceID, m_nIndex, m_nTypeID)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL501F_GetTotalDecodeInkPointsNumber(deviceID)
#==========================================================================
def API_PPL501F_GetTotalDecodeInkPointsNumber():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL501F_GetTotalDecodeInkPointsNumber
    func.argtypes = [c_int32]
    func.restype = c_int32
    return func

__PPL501F_GetTotalDecodeInkPointsNumber = API_PPL501F_GetTotalDecodeInkPointsNumber()

def PPL501F_GetTotalDecodeInkPointsNumber(deviceID):
    m_deviceID = c_int32(deviceID)
    m_nResult = c_int32()
    m_nResult = __PPL501F_GetTotalDecodeInkPointsNumber(m_deviceID)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL501F_SetSaveClipImageMargin(deviceID, bClipImage, nClipMarginX, nClipMarginY)
#==========================================================================
def API_PPL501F_SetSaveClipImageMargin():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL501F_SetSaveClipImageMargin
    func.argtypes = [c_int32, c_bool, c_int32, c_int32]
    func.restype = c_int32
    return func

__PPL501F_SetSaveClipImageMargin = API_PPL501F_SetSaveClipImageMargin()

def PPL501F_SetSaveClipImageMargin(deviceID, bClipImage, nClipMarginX, nClipMarginY):
    m_deviceID = c_int32(deviceID)
    m_bClipImage = c_bool(bClipImage)
    m_nClipMarginX = c_int32(nClipMarginX)
    m_nClipMarginY = c_int32(nClipMarginY)
    m_bResult = c_int32()
    m_bResult = __PPL501F_SetSaveClipImageMargin(m_deviceID, m_bClipImage, m_nClipMarginX, m_nClipMarginY)
    return m_bResult
#==========================================================================
#
#==========================================================================
# PPL501F_SaveDrawingImage(deviceID, nImageTypeID, pwImageFilePath, nDPILevel)
#==========================================================================
def API_PPL501F_SaveDrawingImage():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL501F_SaveDrawingImage
    func.argtypes = [c_int32, c_int32, c_wchar_p, c_int32]
    func.restype = c_int32
    return func

__PPL501F_SaveDrawingImage = API_PPL501F_SaveDrawingImage()

def PPL501F_SaveDrawingImage(deviceID, nImageTypeID, pwImageFilePath, nDPILevel):
    m_deviceID = c_int32(deviceID)
    m_nImageTypeID = c_int32(nImageTypeID)
    m_pwImageFilePath = pwImageFilePath
    m_nDPILevel = c_int32(nDPILevel)
    m_nResult = c_int32()
    m_nResult = __PPL501F_SaveDrawingImage(m_deviceID, m_nImageTypeID, m_pwImageFilePath, m_nDPILevel)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL501F_GetInkPointData(deviceID, currentInkPoint)
#==========================================================================
def API_PPL501F_GetInkPointData():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL501F_GetInkPointData
    func.argtypes = [c_int32, POINTER(INKPOINTDATA)]
    func.restype = c_int32
    return func

__PPL501F_GetInkPointData = API_PPL501F_GetInkPointData()

def PPL501F_GetInkPointData(deviceID, currentInkPoint):
    m_deviceID = c_int32(deviceID)
    m_pCurrentInkPoint = byref(currentInkPoint)
    m_nResult = c_int32()
    m_nResult = __PPL501F_GetInkPointData(m_deviceID, m_pCurrentInkPoint)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL501F_GetInkPointDataTimeInfo(deviceID, nIndex)
#==========================================================================
def API_PPL501F_GetInkPointDataTimeInfo():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL501F_GetInkPointDataTimeInfo
    func.argtypes = [c_int32, c_int32]
    func.restype = POINTER(c_char)
    return func

__PPL501F_GetInkPointDataTimeInfo = API_PPL501F_GetInkPointDataTimeInfo()

def PPL501F_GetInkPointDataTimeInfo(deviceID, nIndex):
    m_deviceID = c_int32(deviceID)
    m_nIndex = c_int32(nIndex)
    m_pChar = POINTER(c_char)
    m_pChar = __PPL501F_GetInkPointDataTimeInfo(m_deviceID, m_nIndex)
    return m_pChar
#==========================================================================
#
#==========================================================================
# PPL501F_FreeInkPointDataTimeInfo(deviceID, pData)
#==========================================================================
def API_PPL501F_FreeInkPointDataTimeInfo():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL501F_FreeInkPointDataTimeInfo
    func.argtypes = [c_int32, c_char_p]
    func.restype = None
    return func

__PPL501F_FreeInkPointDataTimeInfo = API_PPL501F_FreeInkPointDataTimeInfo()

def PPL501F_FreeInkPointDataTimeInfo(deviceID, pData):
    m_deviceID = c_int32(deviceID)
    m_pData = pData
    __PPL501F_FreeInkPointDataTimeInfo(m_deviceID, m_pData)
#==========================================================================
#
#==========================================================================
# PPL501F_GetDeviceInfo(deviceID, nIndex, Output)
#==========================================================================
def API_PPL501F_GetDeviceInfo():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL501F_GetDeviceInfo
    func.argtypes = [c_int32, c_int32, c_void_p]
    func.restype = c_int32
    return func

__PPL501F_GetDeviceInfo = API_PPL501F_GetDeviceInfo()

def PPL501F_GetDeviceInfo(deviceID, nIndex, Output):
    m_deviceID = c_int32(deviceID)
    m_nIndex = c_int32(nIndex)
    m_pOutput = byref(Output)
    m_nResult = c_int32()
    m_nResult = __PPL501F_GetDeviceInfo(m_deviceID, m_nIndex, m_pOutput)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL501F_SignPadEventCallback(deviceID, SIGNPAD_EVENT_CALLBACK pSignPadEventCallback)
#==========================================================================
def API_PPL501F_SignPadEventCallback():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL501F_SignPadEventCallback
    func.argtypes = [c_int32, SIGNPAD_EVENT_CALLBACK]
    func.restype = c_int32
    return func

__PPL501F_SignPadEventCallback = API_PPL501F_SignPadEventCallback()

def PPL501F_SignPadEventCallback(deviceID, pSignPadEventCallback):
    m_deviceID = c_int32(deviceID)
    m_pSignPadEventCallback = pSignPadEventCallback
    m_nResult = c_int32()
    m_nResult = __PPL501F_SignPadEventCallback(m_deviceID, m_pSignPadEventCallback)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL501F_GetHWPenID(deviceID, pPenID, nMaxCount)
#==========================================================================
def API_PPL501F_GetHWPenID():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL501F_GetHWPenID
    func.argtypes = [c_int32, c_void_p, c_int32]
    func.restype = c_int32
    return func

__PPL501F_GetHWPenID = API_PPL501F_GetHWPenID()

def PPL501F_GetHWPenID(deviceID, pPenID, nMaxCount):
    m_deviceID = c_int32(deviceID)
    m_pPenID = byref(pPenID)
    m_nMaxCount = c_int32(nMaxCount)
    m_nResult = c_int32()
    m_nResult = __PPL501F_GetHWPenID(m_deviceID, m_pPenID, m_nMaxCount)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL501F_GetHWVersion(deviceID, pVersion, nMaxCount)
#==========================================================================
def API_PPL501F_GetHWVersion():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL501F_GetHWVersion
    func.argtypes = [c_int32, c_void_p, c_int32]
    func.restype = c_int32
    return func

__PPL501F_GetHWVersion = API_PPL501F_GetHWVersion()

def PPL501F_GetHWVersion(deviceID, pVersion, nMaxCount):
    m_deviceID = c_int32(deviceID)
    m_pVersion = byref(pVersion)
    m_nMaxCount = c_int32(nMaxCount)    
    m_nResult = c_int32()
    m_nResult = __PPL501F_GetHWVersion(m_deviceID, m_pVersion, m_nMaxCount)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL501F_GetHWPadID(deviceID, pPadID, nMaxCount)
#==========================================================================
def API_PPL501F_GetHWPadID():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL501F_GetHWPadID
    func.argtypes = [c_int32, c_void_p, c_int32]
    func.restype = c_int32
    return func

__PPL501F_GetHWPadID = API_PPL501F_GetHWPadID()

def PPL501F_GetHWPadID(deviceID, pPadID, nMaxCount):
    m_deviceID = c_int32(deviceID)
    m_pPadID = byref(pPadID)
    m_nMaxCount = c_int32(nMaxCount)    
    m_nResult = c_int32()
    m_nResult = __PPL501F_GetHWPadID(m_deviceID, m_pPadID, m_nMaxCount)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL501F_DisplayHWVersion(deviceID, bOn)
#==========================================================================
def API_PPL501F_DisplayHWVersion():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL501F_DisplayHWVersion
    func.argtypes = [c_int32, c_bool]
    func.restype = c_int32
    return func

__PPL501F_DisplayHWVersion = API_PPL501F_DisplayHWVersion()

def PPL501F_DisplayHWVersion(deviceID, bOn):
    m_deviceID = c_int32(deviceID)
    m_bOn = c_bool(bOn)
    m_nResult = c_int32()
    m_nResult = __PPL501F_DisplayHWVersion(m_deviceID, m_bOn)
    return m_nResult
#==========================================================================
#
#==========================================================================
# PPL501F_OpenLCD(deviceID, bOn)
#==========================================================================
def API_PPL501F_OpenLCD():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL501F_OpenLCD
    func.argtypes = [c_int32, c_bool]
    func.restype = c_int32
    return func

__PPL501F_OpenLCD = API_PPL501F_OpenLCD()

def PPL501F_OpenLCD(deviceID, bOn):
    m_deviceID = c_int32(deviceID)
    m_bOn = c_bool(bOn)
    m_nResult = c_int32()
    m_nResult = __PPL501F_OpenLCD(m_deviceID, m_bOn)
    return m_nResult
#==========================================================================
#
#======================================================================================================================
# PPL501F_SetDisplayedFPImageAt(deviceID, widgetPtr, nCanvasWidth, nCanvasHeight, nFPLeft, nFPTop, nFPWidth, nFPHeight)
#======================================================================================================================
def API_PPL501F_SetDisplayedFPImageAt():
    dll = CDLL('./libppsignpadsdk.so')
    func = dll.PPL501F_SetDisplayedFPImageAt
    func.argtypes = [c_int32, c_void_p, c_int32, c_int32, c_int32, c_int32, c_int32, c_int32]
    func.restype = c_int32
    return func

__PPL501F_SetDisplayedFPImageAt = API_PPL501F_SetDisplayedFPImageAt()

def PPL501F_SetDisplayedFPImageAt(deviceID, widgetPtr, nCanvasWidth, nCanvasHeight, nFPLeft, nFPTop, nFPWidth, nFPHeight):
    m_deviceID = c_int32(deviceID)
    m_pWidget = cast(widgetPtr, c_void_p)
    m_nCanvasWidth = c_int32(nCanvasWidth)
    m_nCanvasHeight = c_int32(nCanvasHeight)
    m_nFPLeft = c_int32(nFPLeft)
    m_nFPTop = c_int32(nFPTop)
    m_nFPWidth = c_int32(nFPWidth)
    m_nFPHeight = c_int32(nFPHeight)
    m_nResult = c_int32()
    m_nResult = __PPL501F_SetDisplayedFPImageAt(m_deviceID, m_pWidget, m_nCanvasWidth, m_nCanvasHeight, m_nFPLeft, m_nFPTop, m_nFPWidth, m_nFPHeight)
    return m_nResult
#======================================================================================================================

