/* global jQuery */
/*eslint-disable*/

'use strict';

// API Url
var websocket = null;
var wsUrl = 'ws://localhost:6089';

// =========================================
// global variables definition...
var canvas;
var context;
var LastSignatureBase64Data;
var bInitWebSocket = false;
var isPolling = false;
// =========================================

// initialize device
function initDevice() {
    bInitWebSocket = true;
    initWebSocket();
}

// initialize canvas and setup context
window.onload = function () {
    canvas = document.getElementById('ppCanvas');

    if (canvas.getContext) {
        context = canvas.getContext('2d');
    }
};

window.onbeforeunload = function (e) {
    uninitDevice();
};

// initialize Web Socket
function initWebSocket() {
    try {
        if ( websocket && websocket.readyState == 1 )
            websocket.close();

        websocket = new WebSocket( wsUrl );
        websocket.onopen = function (evt) {
            // CONNECTED...
            bInitWebSocket = false;
            doInitDevice();
        };
        websocket.onclose = function (evt) {
            // DISCONNECTED...
            if(bInitWebSocket) {
                bInitWebSocket = false;
                alert('please run PPCPWSSignDriver(.exe) first !');
            }
        };
        websocket.onmessage = function (evt) {
            // message coming from local server...
            var dataInfos = JSON.parse(evt.data);
            processWebSocketResponse(dataInfos);
        };       
        websocket.onerror = function (evt) {
            // ERROR : value at evt.data !
//            alert('initWebSocket() error: ' + evt.data);
        };
    }
    catch (exception) {
        // exception error !
        bInitWebSocket = false;
        alert('initWebSocket() exception error: ' + exception);
    }
}

function processWebSocketResponse(wsResponse) {
    var FunctionName = wsResponse.Func;
    var Result = wsResponse.Result;

    if(FunctionName == 'InitialDevice') {
        if(Result == '1') {
            isPolling = true;
            getInk();

            $('.init').removeAttr('disabled');
            $('#initBtn').attr('disabled', 'disabled');            
        } else {
            alert('No device!');
        }
    }
    else if(FunctionName == 'UnInitialDevice') {
        if(Result == '1') {
            if ( websocket && websocket.readyState == 1 )
                websocket.close();

            var encodeArea = $('#encode');
            var decodeArea = $('#decode');
            var canvas = document.getElementById('ppCanvas');
            context.clearRect(0, 0, canvas.width, canvas.height);
            encodeArea.text("");
            decodeArea.text("");

            $('#penColor').val("1");
            $('#penWidth').val("3");
            $('#penStyle').val("0");
            $('.init').attr('disabled', 'disabled');
            $('#initBtn').removeAttr('disabled');
        }
    }
    else if(FunctionName == 'GetInks') {
        if(Boolean(Result)) {
            var dataInfos = JSON.parse(Result);
            var inkData = dataInfos[0];

            if (inkData.EventType == '0') {
                drawImage(inkData.Image);
                LastSignatureBase64Data = inkData.Image;
            }
        }

        if(isPolling)
            getInk();
        else {}
    }
    else if(FunctionName == 'GetDeviceConfirmOrCancelKeyStatus') {
        if (Result == '1') {
            alert('Notify From Device : Confirmed.');
            var canvas = document.getElementById('ppCanvas');
                        context.clearRect(0, 0, canvas.width, canvas.height);
            drawImage(LastSignatureBase64Data);
        } else if (Result == '0') {
            alert('Notify From Device : Cancel !');
            clearInk();
        }
    }
    else if(FunctionName == 'Clear') {
        var canvas = document.getElementById('ppCanvas');
        context.clearRect(0, 0, canvas.width, canvas.height);
    }
    else if(FunctionName == 'OpenLCD') {
        $('.shutdown').fadeOut('fast');
    }
    else if(FunctionName == 'CloseLCD') {
        $('.shutdown').fadeIn('fast');
    }
    else if(FunctionName == 'SetPenColor') {
    }
    else if(FunctionName == 'SetPenWidth') {
        clearInk();
    }
    else if(FunctionName == 'SetPenStyle') {
    }
    else if(FunctionName == 'SaveDrawingImage') {
        if (Boolean(parseInt(Result))) {
            alert('Save file ' + localPath + ' failed' + ', result=' + Result);
        } else {
            alert('File：' + Result + ' saved');
        }
    }
    else if(FunctionName == 'SetClip') {
    }
    else if(FunctionName == 'GetSize') {
        if (Result == '-8') {
            alert('Ink Empty.\nresult=' + Result);
        } else {
            alert('result=' + Result);
        }
    }
    else if(FunctionName == 'GetPointer') {
        var oJson = JSON.parse(Result);
        var dataLength = oJson.length;
        var pointcontent = $('#pointContent');
        pointcontent.empty();
    
        if (dataLength === 0) {
            alert('Point information is empty.');
        } else {
            $('#myModal').modal('show');
            for (var i = 0; i < dataLength; i++) {
                pointcontent.append('<tr><td>' + oJson[i].x + '</td><td>' + oJson[i].y + '</td><td align="right">' + oJson[i].pressure + '</td><td align="right">' + oJson[i].bStrokeEnd + '</td><td align="right">' + oJson[i].Time + '</td></tr>');
            }
        }
    }
    else if(FunctionName == 'GetAboutInfo') {
        alert(Result);
    }
    else if(FunctionName == 'VersionID') {
        alert(Result);
    }
    else if(FunctionName == 'PadID') {
        alert(Result);
    }
    else if(FunctionName == 'PenID') {
        alert(Result);
    }
    else if(FunctionName == 'ShowDeviceInfoOnLCD') {
    }
    else if(FunctionName == 'GetDeviceInfo') {
        var diVal = $('#devInfo').val();

        if (diVal == 1) {
            if (Result === "true") {
                alert('Connected\nresult=' + Result);
            } else {
                alert('Disconnected\nresult=' + Result);
            }
        } else {
            alert(Result);
        }
    }
    else if(FunctionName == 'Encode') {
        var encodeArea = $('#encode');
        encodeArea.text(Result);
    }
    else if(FunctionName == 'Decode') {
        var encodeType = $('#encodeType').val();
        var decodeArea = $('#decode');

        if (encodeType == 6) {
            decodeArea.append('X\t\t\t\tY\t\t\t\tbStrokeEnd\n');
            var data = JSON.parse(Result);
            for (var i = 0; i < data.length; i++) {
                var x = data[i].x,
                    y = data[i].y,
                    bStrokeEnd = data[i].bStrokeEnd;

                decodeArea.append(x + '\t\t\t\t' + y + '\t\t\t\t' + bStrokeEnd + '\n');
            }
        }
        else {
            DoGetDecodeFilePath();
        }
    }
    else if(FunctionName == 'GetDecodeFilePath') {
        alert('File：' + Result + '\nSaved.');        
    }
};

function doInitDevice() {
    var jsParam =
    {
        "Func": "InitialDevice",
        "id": "5",
        "width": "600",
        "height": "375"
    };
    var strCmdJsonData = JSON.stringify(jsParam);

    // send urlInitDevice...
    var urlInitDevice = strCmdJsonData;
    websocket.send(urlInitDevice);
}

// uninitialize device
function uninitDevice() {
    isPolling = false;    
    var jsParam =
    {
        "Func": "UnInitialDevice",
        "id": "5",
    };
    var strCmdJsonData = JSON.stringify(jsParam);

    // send urlUnInitDevice...
    var urlUnInitDevice = strCmdJsonData;
    websocket.send(urlUnInitDevice);
}

function getInk() {
    var timeId = setTimeout(function () {
        clearTimeout(timeId);

        if (isPolling) {
            getInksData();
        }
    }, 10);
};

// get inks data...
function getInksData() {
    var jsParam =
    {
        "Func": "GetInks",
    };
    var strCmdJsonData = JSON.stringify(jsParam);

    // send urlGetInksData...
    var urlGetInksData = strCmdJsonData;
    websocket.send(urlGetInksData);
};

// get about
function getAbout() {
    var jsParam =
    {
        "Func": "GetAboutInfo",
    };
    var strCmdJsonData = JSON.stringify(jsParam);

    // send urlAbout...
    var urlAbout = strCmdJsonData;
    websocket.send(urlAbout);
};

// clear Ink
function clearInk() {
    var jsParam =
    {
        "Func": "Clear",
    };
    var strCmdJsonData = JSON.stringify(jsParam);

    // send urlAbout...
    var urlClearInk = strCmdJsonData;
    websocket.send(urlClearInk);
};

// pen color change case
function pcChange() {
    var colorIndex = $('#penColor').val();
    var R, G, B;

    switch(colorIndex) {
        case '1':   // Black color...
            R = 0;
            G = 0;
            B = 0;
            break;
        case '2':   // Red color...
            R = 255;
            G = 0;
            B = 0;
            break;
        case '3':   // Green color...
            R = 0;
            G = 255;
            B = 0;
            break;
        case '4':   // Blue color...
            R = 0;
            G = 0;
            B = 255;
            break;
        case '5':   // Yellow color...
            R = 255;
            G = 255;
            B = 0;
            break;
    }

    var jsParam =
    {
        "Func": "SetPenColor",
        "r": String(R),
        "g": String(G),
        "b": String(B)
    };
    var strCmdJsonData = JSON.stringify(jsParam);

    // send urlSetPenColor...
    var urlSetPenColor = strCmdJsonData;
    websocket.send(urlSetPenColor);
};

// pen width change case
function pwChange() {
    var pwVal = $('#penWidth').val();
    var jsParam =
    {
        "Func": "SetPenWidth",
        "width": String(pwVal)
    };
    var strCmdJsonData = JSON.stringify(jsParam);

    // send urlSetPenWidth...
    var urlSetPenWidth = strCmdJsonData;
    websocket.send(urlSetPenWidth);
};

//  pen style change case
function psChange() {
    var psVal = $('#penStyle').val();
    var jsParam =
    {
        "Func": "SetPenStyle",
        "style": String(psVal)
    };
    var strCmdJsonData = JSON.stringify(jsParam);

    // send urlSetPenStyle...
    var urlSetPenStyle = strCmdJsonData;
    websocket.send(urlSetPenStyle);
};

// save drawing images
function saveDrawing() {
    var getsdType = $('#sdType').val();
    var getsdDpi = $('#sdDpi').val();
    var localPath = 'DrawImage_' + generateString(5);
    var sdT;

    switch (getsdType) {
        case '1':
            sdT = '.BMP';
            break;
        case '2':
            sdT = '.JPG';
            break;
        case '3':
            sdT = '.PNG';
            break;
        case '7':
            sdT = '.PDF';
            break;
        case '8':
            sdT = '.SVG';
            break;
    };

    var jsParam =
    {
        "Func": "SaveDrawingImage",
        "type": String(getsdType),
        "dpi": String(getsdDpi),
        "path": localPath + sdT
    };
    var strCmdJsonData = JSON.stringify(jsParam);

    // send urlSaveDrawingImage...
    var urlSaveDrawingImage = strCmdJsonData;
    websocket.send(urlSaveDrawingImage);
};

// get size
function getSize() {
    var jsParam =
    {
        "Func": "GetSize"
    };
    var strCmdJsonData = JSON.stringify(jsParam);

    // send urlGetSize...
    var urlGetSize = strCmdJsonData;
    websocket.send(urlGetSize);
};

// get pointer
function getPointer() {
    var jsParam =
    {
        "Func": "GetPointer"
    };
    var strCmdJsonData = JSON.stringify(jsParam);

    // send urlGetPointer...
    var urlGetPointer = strCmdJsonData;
    websocket.send(urlGetPointer);
};

// Set clip
function setClip() {

    var scWidth = $('#scWidth').val();
    var scHeight = $('#scHeight').val();

    if (!scWidth || scWidth < 0) {
        alert('Insert Width!');
        return;
    };
    if (!scHeight || scHeight < 0) {
        alert('Insert height!');
        return;
    };

    var canvas = document.getElementById('ppCanvas');
    context.clearRect(0, 0, canvas.width, canvas.height);

    var jsParam =
    {
        "Func": "SetClip",
        "width": String(scWidth),
        "height": String(scHeight)
    };
    var strCmdJsonData = JSON.stringify(jsParam);

    // send urlSetClip...
    var urlSetClip = strCmdJsonData;
    websocket.send(urlSetClip);
};

// get pad id
function getPadid() {
    var jsParam =
    {
        "Func": "PadID"
    };
    var strCmdJsonData = JSON.stringify(jsParam);

    // send urlGetPadID...
    var urlGetPadID = strCmdJsonData;
    websocket.send(urlGetPadID);
};

// get pen id
function getPenid() {
    var jsParam =
    {
        "Func": "PenID"
    };
    var strCmdJsonData = JSON.stringify(jsParam);

    // send urlGetPenID...
    var urlGetPenID = strCmdJsonData;
    websocket.send(urlGetPenID);
};

// get version id
function getVerid() {
    var jsParam =
    {
        "Func": "VersionID"
    };
    var strCmdJsonData = JSON.stringify(jsParam);

    // send urlGetVersionID...
    var urlGetVersionID = strCmdJsonData;
    websocket.send(urlGetVersionID);
};

// show device info on lcd
function showDeviceInfoOnLCD() {
    var jsParam =
    {
        "Func": "ShowDeviceInfoOnLCD",
        "show": "1"
    };
    var strCmdJsonData = JSON.stringify(jsParam);

    // send urlShowDeviceInfoOnLCD...
    var urlShowDeviceInfoOnLCD = strCmdJsonData;
    websocket.send(urlShowDeviceInfoOnLCD);
};

// hide device info in lcd
function hideDeviceInfoOnLCD() {
    var jsParam =
    {
        "Func": "ShowDeviceInfoOnLCD",
        "show": "0"
    };
    var strCmdJsonData = JSON.stringify(jsParam);

    // send urlShowDeviceInfoOnLCD...
    var urlShowDeviceInfoOnLCD = strCmdJsonData;
    websocket.send(urlShowDeviceInfoOnLCD);
};

// open LCD
function openLCD() {
    var jsParam =
    {
        "Func": "OpenLCD"
    };
    var strCmdJsonData = JSON.stringify(jsParam);

    // send urlOpenLCD...
    var urlOpenLCD = strCmdJsonData;
    websocket.send(urlOpenLCD);
};

// close LCD
function closeLCD() {
    var jsParam =
    {
        "Func": "CloseLCD"
    };
    var strCmdJsonData = JSON.stringify(jsParam);

    // send urlCloseLCD...
    var urlCloseLCD = strCmdJsonData;
    websocket.send(urlCloseLCD);
};

// get device information
function getDevinf() {
    var diVal = $('#devInfo').val();
    var jsParam =
    {
        "Func": "GetDeviceInfo",
        "type": String(diVal)
    };
    var strCmdJsonData = JSON.stringify(jsParam);

    // send urlGetDeviceInfo...
    var urlGetDeviceInfo = strCmdJsonData;
    websocket.send(urlGetDeviceInfo);
};

// Encode
function encode() {
    var encodeArea = $('#encode');
    encodeArea.text("");
    var encodeType = $('#encodeType').val();

    var jsParam =
    {
        "Func": "Encode",
        "type": String(encodeType)
    };
    var strCmdJsonData = JSON.stringify(jsParam);

    // send urlEncode...
    var urlEncode = strCmdJsonData;
    websocket.send(urlEncode);
};

// Decode
function decode() {
    var encodeContent = $('#encode').val();
    var encodeType = $('#encodeType').val();
    var decodeFormat;
    var decodeArea = $('#decode');
    decodeArea.text("");

    switch (encodeType) {
        case '1':
            decodeFormat = '.BMP';
            break;
        case '2':
            decodeFormat = '.JPG';
            break;
        case '3':
            decodeFormat = '.PNG';
            break;
    }

    if (encodeType == 6) {
        var jsParam =
        {
            "Func": "Decode",
            "type": String(encodeType),
            "data": String(encodeContent)
        };
        var strCmdJsonData = JSON.stringify(jsParam);
    
        // send urlDecodeInkData...
        var urlDecodeInkData = strCmdJsonData;
        websocket.send(urlDecodeInkData);
    } else {
        var jsParam =
        {
            "Func": "Decode",
            "type": String(encodeType),
            "data": String(encodeContent),
            "path": "Decode_Image_" + generateString(5) + decodeFormat
        };
        var strCmdJsonData = JSON.stringify(jsParam);
    
        // send urlDecodeInkData...
        var urlDecodeInkData = strCmdJsonData;
        websocket.send(urlDecodeInkData);
    };
};

function drawImage(base64) {
    var dataUrl = 'data:image/png;base64,';

    dataUrl = dataUrl + base64;

    // 在image中載入圖檔，再畫到canvas呈現
    var img = new Image();

    img.addEventListener('load', function () {
        context.drawImage(this, 0, 0, canvas.width, canvas.height);
    }, false);

    img.src = dataUrl;
};

// Generate random number
function generateString(length) {
    var text = "";
    var possible = "0123456789";

    for (var i = 0; i < length; i++) {
        text += possible.charAt(Math.floor(Math.random() * possible.length));
    }return text;
}

function DoGetDecodeFilePath() {
    var jsParam =
    {
        "Func": "GetDecodeFilePath"
    };
    var strCmdJsonData = JSON.stringify(jsParam);
    
    // send urlGetDecodeFilePath...
    var urlGetDecodeFilePath = strCmdJsonData;
    websocket.send(urlGetDecodeFilePath);
}
