/* global jQuery */
/*eslint-disable*/

'use strict';

// API Url
var websocket = null;
var wsUrl = 'ws://localhost:7060';

// Http Command ID definition...
const CMDID_ERR_URL_PATH = -1;
const CMDID_OUT_OF_COMMAND_RANGE = -2;
const CMDID_INITIAL = 1;
const CMDID_GET_VERSION = 2;
const CMDID_GET_SIGNPAD_ID = 3;
const CMDID_UNINITIAL = 4;
const CMDID_SIGN_COMPLETED = 5;
const CMDID_SERVICE_REVIEWS_COMPLETED = 6;
const CMDID_UPDATE_SIGN_CANVAS_INFO = 7;
const CMDID_PUSH_WEBPAGE_TO_SIGNPAD = 8;
const CMDID_ENABLE_SIGNPAD_MOUSE = 9;
const CMDID_CLEAR_SIGN_CANVAS_DATA = 10;
const CMDID_GET_SIGN_IMAGE_BASE64_DATA = 11;
const CMDID_GET_MULTI_SIGN_IMAGE_BASE64_DATA = 12;
const CMDID_MULTI_SIGN_COMPLETED = 13;

// pen width level
const PEN_WIDTH_LEVEL_1 = 1;
const PEN_WIDTH_LEVEL_2 = 2;
const PEN_WIDTH_LEVEL_3 = 3;
const PEN_WIDTH_LEVEL_4 = 4;
const PEN_WIDTH_LEVEL_5 = 5;
const PEN_WIDTH_LEVEL_6 = 6;
const PEN_WIDTH_LEVEL_7 = 7;
const PEN_WIDTH_LEVEL_8 = 8;
const PEN_WIDTH_LEVEL_9 = 9;
const PEN_WIDTH_LEVEL_10 = 10;

// global variables definition...
var bInitWebSocket = false;
var SelectedScore = 0;

// initialize device
function Initial() {
  bInitWebSocket = true;
  initWebSocket();
}

// initialize Web Socket
function initWebSocket() {
  try {
      if ( websocket && websocket.readyState == 1 )
          websocket.close();

      websocket = new WebSocket( wsUrl );
      websocket.onopen = function (evt) {
          // CONNECTED...
          bInitWebSocket = false;
          initDevice();
      };
      websocket.onclose = function (evt) {
          // DISCONNECTED...
          if(bInitWebSocket) {
              bInitWebSocket = false;
              const platform = navigator.platform.toLowerCase();
              if (platform.includes('win')) {
                alert('please run PPWSWebSignDriver.exe first !');
              } else if (platform.includes('linux')) {
                alert('please run WebSignDriver first !');
              }
          }
      };
      websocket.onmessage = function (evt) {
          // message coming from local server...
          var dataInfos = JSON.parse(evt.data);
          processCmdResult(dataInfos);

	   if(pollingSignPadGetCommandResult) {
		SignPadGetCommandResult();
	   }
      };       
      websocket.onerror = function (evt) {
          // ERROR : value at evt.data !
            alert('initWebSocket() error: ' + evt.data);
      };
  }
  catch (exception) {
      // exception error !
      bInitWebSocket = false;
      alert('initWebSocket() exception error: ' + exception);
  }
}

function initDevice() {
  EnableSignPadMouse();
}

function processCmdResult(wsResponse) {
  var Command = wsResponse.Command;
  var Result = wsResponse.Result;

  if(Command == CMDID_ENABLE_SIGNPAD_MOUSE) {
  	if(Result == 'Success') {
       } else if(Result == 'Failed') {
       } 
  }
  else if(Command == CMDID_SERVICE_REVIEWS_COMPLETED) {
  	if(Result == 'Success') {
       } else if(Result == 'Failed') {
       } 
  }
}

// enable signpad mouse...
function EnableSignPadMouse() {
  // enable signpad mouse...
  var jsParam =
  {
    "Command": CMDID_ENABLE_SIGNPAD_MOUSE,
    "Data": "true"
  };

  var strCmdJsonData = JSON.stringify(jsParam);

  // send urlEnableSignPadMouse...
  var urlEnableSignPadMouse = strCmdJsonData;
  websocket.send(urlEnableSignPadMouse);
}

function cbCheck(num) {
  SelectedScore = num;
  var elements = document.getElementsByClassName('checkmark');
  for(var i=0;i<5;i++) {
    if(i<SelectedScore) {
      elements[i].className = 'cbSelected ' + 'checkmark s'+(i+1);
    }
    else {
      elements[i].className = 'checkmark s'+(i+1);
    }
  }
  document.getElementById("btnSend").disabled = false;
}

function reset() {
  var elements = document.getElementsByClassName('checkmark');
  for(var i=0;i<5;i++) {
    if(i<SelectedScore) {
      elements[i].className = 'cbSelected ' + 'checkmark s'+(i+1);
    }
    else {
      elements[i].className = 'checkmark s'+(i+1);
    }
  }
}

function SendScore() {
  Uninitial();  
  HideButton();

  // send score back to console web page...
  var jsParam =
  {
    "Command": CMDID_SERVICE_REVIEWS_COMPLETED,
    "Data": SelectedScore.toString()
  };
  var strCmdJsonData = JSON.stringify(jsParam);

  // send urlEnableSignPadMouse...
  var urlServiceReviewsCompleted = strCmdJsonData;
  websocket.send(urlServiceReviewsCompleted);
}

window.onbeforeunload = function(e) {
/*  
  Uninitial();

  var milliseconds = 10;
  var start = new Date().getTime();

  while(true) {
    if ((new Date().getTime() - start) > milliseconds)
    break;
  }
*/  
}

function Uninitial() {
  // disable signpad mouse...
  var jsParam =
  {
    "Command": CMDID_ENABLE_SIGNPAD_MOUSE,
    "Data": "false"
  };
  var strCmdJsonData = JSON.stringify(jsParam);

  // send urlEnableSignPadMouse...
  var urlEnableSignPadMouse = strCmdJsonData;
  websocket.send(urlEnableSignPadMouse);
}

function HideButton() {
  document.getElementById("btnSend").style.display = "none";
}
