/* global jQuery */
/*eslint-disable*/

'use strict';

// API Url
var websocket = null;
var wsUrl = 'ws://localhost:7059';
var domainNameUrl = null;

// 本地端測試
var loc = window.location.pathname;
domainNameUrl = loc.substring(1, loc.lastIndexOf('/'));
domainNameUrl = domainNameUrl.replaceAll("%20", " ");

/*
// 伺服器端測試
if (location.protocol != 'wss:') {
//  domainNameUrl = 'ws://domainName/';
}
else {
//  domainNameUrl = 'wss://domainName/';
}
*/

// ws Command ID definition...
const CMDID_ERR_URL_PATH              = -1;
const CMDID_OUT_OF_COMMAND_RANGE      = -2;
const CMDID_INITIAL                   = 1;
const CMDID_GET_VERSION               = 2;
const CMDID_GET_SIGNPAD_ID            = 3;
const CMDID_UNINITIAL                 = 4;
const CMDID_SIGN_COMPLETED            = 5;
const CMDID_SERVICE_REVIEWS_COMPLETED = 6;
const CMDID_UPDATE_SIGN_CANVAS_INFO   = 7;
const CMDID_PUSH_WEBPAGE_TO_SIGNPAD   = 8;
const CMDID_ENABLE_SIGNPAD_MOUSE      = 9;
const CMDID_CLEAR_SIGN_CANVAS_DATA    = 10;
const CMDID_GET_SIGN_IMAGE_BASE64_DATA = 11;
const CMDID_GET_MULTI_SIGN_IMAGE_BASE64_DATA = 12;
const CMDID_MULTI_SIGN_COMPLETED = 13;
const CMDID_CLOSE_PUSH_WEBPAGE_TYPE_SIGN = 18;
const CMDID_CLOSE_PUSH_WEBPAGE_TYPE_MULTI_SIGN = 19;
const CMDID_SEND_MSG_FROM_CONSOLE_WEBPAGE = 20;
const CMDID_SEND_MSG_FROM_SIGNPAD_WEBPAGE = 21;

// pen width level
const PEN_WIDTH_LEVEL_1 = 1;
const PEN_WIDTH_LEVEL_2 = 2;
const PEN_WIDTH_LEVEL_3 = 3;
const PEN_WIDTH_LEVEL_4 = 4;
const PEN_WIDTH_LEVEL_5 = 5;
const PEN_WIDTH_LEVEL_6 = 6;
const PEN_WIDTH_LEVEL_7 = 7;
const PEN_WIDTH_LEVEL_8 = 8;
const PEN_WIDTH_LEVEL_9 = 9;
const PEN_WIDTH_LEVEL_10 = 10;

// pen style...
const PEN_STYLE_WITH_PRESSURE = 1;
const PEN_STYLE_FIX = 2;

// type of push webpage to signpad...
const PUSH_WEBPAGE_TYPE_AD = 1;
const PUSH_WEBPAGE_TYPE_SIGN = 2;
const PUSH_WEBPAGE_TYPE_MULTI_SIGN = 3;
const PUSH_WEBPAGE_TYPE_SERVICE_REVIEWS = 4;

// global variables definition...
var CurrentPushMode = -1;
var lastSignImageBase64Data = null;
var lastSignImageBase64Data2 = null;
var lastSignImageBase64Data3 = null;
var lastSignSVGImageBase64Data = null;
var lastSignSVGImageBase64Data2 = null;
var lastSignSVGImageBase64Data3 = null;
var lastFPFeatureBase64Data = null;
var lastFPFeatureBase64Data2 = null;
var lastFPFeatureBase64Data3 = null;
var lastPDFBase64Data = null;
var LastSignMode = -1;
var LastSignId = 0;

var contractWindowProxy = null;
var multiSignContractWindowProxy = null;
var bInitWebSocket = false;

String.prototype.replaceAll = function(search, replacement) {
  var target = this;
  return target.replace(new RegExp(search, 'g'), replacement);
};

function isEmpty(str) {
    return (!str || 0 === str.length);
}

// initialize device
function Initial() {
  bInitWebSocket = true;
  initWebSocket();
}

// initialize Web Socket
function initWebSocket() {
  try {
      if ( websocket && websocket.readyState == 1 )
          websocket.close();

      websocket = new WebSocket( wsUrl );
      websocket.onopen = function (evt) {
          // CONNECTED...
          bInitWebSocket = false;
          initDevice();
      };
      websocket.onclose = function (evt) {
          // DISCONNECTED...
          if(bInitWebSocket) {
              bInitWebSocket = false;
              const platform = navigator.platform.toLowerCase();
              if (platform.includes('win')) {
                alert('please run PPWSWebSignDriver.exe first !');
              } else if (platform.includes('linux')) {
                alert('please run WebSignDriver first !');
              }
          }
      };
      websocket.onmessage = function (evt) {
          // message coming from local server...
          var dataInfos = JSON.parse(evt.data);
          processCmdResult(dataInfos);
      };
      websocket.onerror = function (evt) {
          // ERROR : value at evt.data !
          alert('initWebSocket() error: ' + evt.data);
      };
  }
  catch (exception) {
      // exception error !
      bInitWebSocket = false;
      alert('initWebSocket() exception error: ' + exception);
  }
}

// initialize device
function initDevice() {

  document.getElementById("displayType").innerHTML = '初始化签字板设备...';

  // initial device...
  var jsParamm =
  {
    "Command": CMDID_INITIAL,
    "Data": null
  };
  var strCmdJsonData = JSON.stringify(jsParamm);

  // send urlInitDevice to initial device...
  var urlInitDevice = strCmdJsonData;
  websocket.send(urlInitDevice);
}

function processCmdResult(wsResponse) {
  var Command = wsResponse.Command;
  var Result = wsResponse.Result;

  if(Command == CMDID_OUT_OF_COMMAND_RANGE) {
  	alert('Out Of Command Range !');
  }
  else if(Command == CMDID_ERR_URL_PATH) {
  	alert('Invalid URL Path !');
  }
  else if(Command == CMDID_INITIAL) {
  	if(Result == 'Success') {
          document.getElementById("displayType").innerHTML = '签字板设备已连接上。';
          document.getElementById("ShowContractBtn").disabled = false;
          document.getElementById("MultiSignBtn").disabled = false;
          document.getElementById("ShowADBtn").disabled = false;          
          document.getElementById("SendMsgFromConsoleWebPageBtn").disabled = false;
          document.getElementById("CloseShowContractBtn").disabled = false;
          document.getElementById("CloseMultiSignBtn").disabled = false;
          document.getElementById("HWIDBtn").disabled = false;
          document.getElementById("ScoreBtn").disabled = false;
          document.getElementById("GetVersionBtn").disabled = false;
          PushADWebPageToSignPad();
       } else if(Result == 'Failed') {
          alert('SignPad Device Not Found !');
       } 
  }
  else if(Command == CMDID_GET_VERSION) {
  	if(Result == 'Success') {
          var Version = wsResponse.Data;
          alert('PenPower LD1000 SDK Cross-Platform Version : ' + Version);
       } else if(Result == 'Failed') {
          alert('Failed to get version !');
       } 
  }
  else if(Command == CMDID_GET_SIGNPAD_ID) {
  	if(Result == 'Success') {
          var SignPadID = wsResponse.Data;
          document.getElementById("HWID").innerHTML = SignPadID;
       }
  }
  else if(Command == CMDID_PUSH_WEBPAGE_TO_SIGNPAD) {
  	var nPushWebPageType = parseInt(wsResponse.Data);
    if(nPushWebPageType == PUSH_WEBPAGE_TYPE_AD) {
            if(Result == 'Success') {
              document.getElementById("displayType").innerHTML = '推屏广告页面成功。';
            }
            else if(Result == 'ExitWebPageDueToSignPadError') {
              document.getElementById("displayType").innerHTML = 'SignPad已被拔除! 请插上后，按F5或离开网页重新执行。';
            }
            else if(Result == 'ExitWebPageDueToScreenLockSuspendMode') {
              document.getElementById("displayType").innerHTML = '屏幕锁定/暂停，待解除后，按F5或离开网页重新执行。';
            }
            else if(Result == 'Failed') {
              alert('Failed to push AD webpage !');
          }             
    }
    else if(nPushWebPageType == PUSH_WEBPAGE_TYPE_SIGN) {
            if(Result == 'Success') {
              document.getElementById("displayType").innerHTML = '推屏空白合同页面成功。';
            }
            else if(Result == 'ExitWebPageDueToSignPadError') {
              document.getElementById("displayType").innerHTML = 'SignPad已被拔除! 请插上后，按F5或离开网页重新执行。';
            }
            else if(Result == 'ExitWebPageDueToScreenLockSuspendMode') {
              document.getElementById("displayType").innerHTML = '屏幕锁定/暂停，待解除后，按F5或离开网页重新执行。';
            }
            else if(Result == 'ExitWebPage') {
              document.getElementById("ReviewContractBtn").disabled = false;
              document.getElementById("ContractSelect").disabled = false;

              // get (current web page saved as) pdf base64 data from wsResponse.Data2...                
              // get sign image base64 data from wsResponse.Data3...
              // get sign SVG image base64 data from wsResponse.Data4...
              // get FP Feature base64 data from wsResponse.Data5...
              // get sign id from wsResponse.Data6...
              lastPDFBase64Data = wsResponse.Data2;
              lastSignImageBase64Data = wsResponse.Data3;
              lastSignSVGImageBase64Data = wsResponse.Data4;
              lastFPFeatureBase64Data = wsResponse.Data5;
              LastSignId = wsResponse.Data6;

              PushADWebPageToSignPad();
            }
            else if(Result == 'Failed') {
              alert('Failed to push Contract webpage !');
            }
    }
    else if(nPushWebPageType == PUSH_WEBPAGE_TYPE_MULTI_SIGN) {
            if(Result == 'Success') {
              document.getElementById("displayType").innerHTML = '推屏单页多签页面成功。';
            }
            else if(Result == 'ExitWebPageDueToSignPadError') {
              document.getElementById("displayType").innerHTML = 'SignPad已被拔除! 请插上后，按F5或离开网页重新执行。';
            }
            else if(Result == 'ExitWebPageDueToScreenLockSuspendMode') {
              document.getElementById("displayType").innerHTML = '屏幕锁定/暂停，待解除后，按F5或离开网页重新执行。';
            }
            else if(Result == 'ExitWebPage') {
              document.getElementById("ReviewContractBtn").disabled = false;
              document.getElementById("ContractSelect").disabled = false;

              // get (current web page saved as) pdf base64 data from wsResponse.Data2...                
              // get multi sign image base64 data 1 from wsResponse.Data3...
              // get multi sign image base64 data 2 from wsResponse.Data4...
              // get multi sign image base64 data 3 from wsResponse.Data5...
              // get multi sign SVG image base64 data 1 from wsResponse.Data6...
              // get multi sign SVG image base64 data 2 from wsResponse.Data7...
              // get multi sign SVG image base64 data 3 from wsResponse.Data8...
              // get multi sign FP Feature base64 data 1 from wsResponse.Data9...
              // get multi sign FP Feature base64 data 2 from wsResponse.Data10...
              // get multi sign FP Feature base64 data 3 from wsResponse.Data11...
              // get sign id from wsResponse.Data12...
              lastPDFBase64Data = wsResponse.Data2;
              lastSignImageBase64Data = wsResponse.Data3;
              lastSignImageBase64Data2 = wsResponse.Data4;
              lastSignImageBase64Data3 = wsResponse.Data5;
              lastSignSVGImageBase64Data = wsResponse.Data6;
              lastSignSVGImageBase64Data2 = wsResponse.Data7;
              lastSignSVGImageBase64Data3 = wsResponse.Data8;
              lastFPFeatureBase64Data = wsResponse.Data9;
              lastFPFeatureBase64Data2 = wsResponse.Data10;
              lastFPFeatureBase64Data3 = wsResponse.Data11;
              LastSignId = wsResponse.Data12;

              PushADWebPageToSignPad();                
            }
            else if(Result == 'Failed') {
              alert('Failed to push Multiple Sign webpage !');
            }             
    }
    else if(nPushWebPageType == PUSH_WEBPAGE_TYPE_SERVICE_REVIEWS) {
            if(Result == 'Success') {
              document.getElementById("displayType").innerHTML = '推屏服务评价页面成功。';
            }
            else if(Result == 'ExitWebPageDueToSignPadError') {
              document.getElementById("displayType").innerHTML = 'SignPad已被拔除! 请插上后，按F5或离开网页重新执行。';
            }
            else if(Result == 'ExitWebPageDueToScreenLockSuspendMode') {
              document.getElementById("displayType").innerHTML = '屏幕锁定/暂停，待解除后，按F5或离开网页重新执行。';
            }
            else if(Result == 'ExitWebPage') {
              document.getElementById("SCOREID").innerHTML = wsResponse.Data2 + ' 星';
              PushADWebPageToSignPad();                
            }
            else if(Result == 'Failed') {
              alert('Failed to push Service Reviews webpage !');
            }             
    }
  }
  else if(Command == CMDID_UNINITIAL) {
  }
  else if(Command == CMDID_SEND_MSG_FROM_SIGNPAD_WEBPAGE) {
    let strRxMsgFromSignPadWebPage = wsResponse.Data;
//    alert('Rx Msg From SignPad WebPage = ' + strRxMsgFromSignPadWebPage);
  }

}

// uninitialize device
function uninitDevice() {
  // uninitial device...
  var jsParamm =
  {
    "Command": CMDID_UNINITIAL,
    "Data": null
  };
  var strCmdJsonData = JSON.stringify(jsParamm);

  // send urlUninitDevice...
  var urlUninitDevice = strCmdJsonData;
  websocket.send(urlUninitDevice);
}

window.onbeforeunload = function (e) {
    uninitDevice();
    var milliseconds = 500;
    var start = new Date().getTime();

    while (true) {
        if (new Date().getTime() - start > milliseconds) {
            break;
        }
    }

    if(contractWindowProxy) {
      contractWindowProxy.close()
      contractWindowProxy = null
    }
  
    if(multiSignContractWindowProxy) {
      multiSignContractWindowProxy.close()
      multiSignContractWindowProxy = null
    }  
}

function PushContractWebPageToSignPad() {
  if(CurrentPushMode===0) {
    return;
  }

  CurrentPushMode = 0;
  LastSignMode = 1;

  document.getElementById("displayType").innerHTML = '正在推屏空白合同页面...';

  // push contract webpage to signpad...
  var jsParamm =
  {
    "Command": CMDID_PUSH_WEBPAGE_TO_SIGNPAD,
    "Data": 
    {
      "type": PUSH_WEBPAGE_TYPE_SIGN,
      "url": encodeURIComponent(domainNameUrl + '/pushed.html'),
    }
  };
  var strCmdJsonData = JSON.stringify(jsParamm);

  // send urlPushContractWebPageToSignPad...
  var urlPushContractWebPageToSignPad = strCmdJsonData;
  websocket.send(urlPushContractWebPageToSignPad);
}

function PushADWebPageToSignPad() {
  if(CurrentPushMode === 1) {
    CurrentPushMode = 2;
  }
  else {
    CurrentPushMode = 1;
  }

  document.getElementById("displayType").innerHTML = '正在推屏广告页面...';

  // push ad webpage to signpad...
  var jsParamm =
  {
    "Command": CMDID_PUSH_WEBPAGE_TO_SIGNPAD,
    "Data": 
    {
      "type": PUSH_WEBPAGE_TYPE_AD,
      "url": encodeURIComponent(domainNameUrl + '/AD' + CurrentPushMode + '.html'),
    }
  };
  var strCmdJsonData = JSON.stringify(jsParamm);

  // send urlPushADWebPageToSignPad...
  var urlPushADWebPageToSignPad = strCmdJsonData;
  websocket.send(urlPushADWebPageToSignPad);
}

function GetVersion() {
  // get version...
  var jsParamm =
  {
    "Command": CMDID_GET_VERSION,
    "Data": null
  };
  var strCmdJsonData = JSON.stringify(jsParamm);

  // send urlGetVersion...
  var urlGetVersion = strCmdJsonData;
  websocket.send(urlGetVersion);
}

function GetHWID() {
  // get signpad id...
  var jsParamm =
  {
    "Command": CMDID_GET_SIGNPAD_ID,
    "Data": null
  };
  var strCmdJsonData = JSON.stringify(jsParamm);

  // send urlGetHWID...
  var urlGetHWID = strCmdJsonData;
  websocket.send(urlGetHWID);
}

function PushServiceReviewsWebPageToSignPad() {
  if(CurrentPushMode===3) {
    return;
  }
  CurrentPushMode = 3;
  document.getElementById("SCOREID").innerHTML = '';
  document.getElementById("displayType").innerHTML = '正在推屏服务评价页面...';

  // push service reviews webpage to signpad...
  var jsParamm =
  {
    "Command": CMDID_PUSH_WEBPAGE_TO_SIGNPAD,
    "Data": 
    {
      "type": PUSH_WEBPAGE_TYPE_SERVICE_REVIEWS,
      "url": encodeURIComponent(domainNameUrl + '/Score.html'),
    }
  };
  var strCmdJsonData = JSON.stringify(jsParamm);

  // send urlPushServiceReviewsWebPageToSignPad...
  var urlPushServiceReviewsWebPageToSignPad = strCmdJsonData;
  websocket.send(urlPushServiceReviewsWebPageToSignPad);
}

function CheckContract() {
  var psVal = $('#ContractSelect').val();

  if(LastSignMode === 1)
  {
    if(psVal === '0') {
      if(isEmpty(lastPDFBase64Data) === true) {
        document.getElementById("displayType").innerHTML = 'No PDF Base64 Data !';
      } else {
        downloadPDFBase64File(lastPDFBase64Data, "signed.pdf");
      }
    }
    else if(psVal === '1') {
      OpenNewContractWebPage();
    }
    else {
      alert('Error !');
    } 
  }
  else if(LastSignMode === 2)
  {
    if(psVal === '0') {
      if(isEmpty(lastPDFBase64Data) === true) {
        document.getElementById("displayType").innerHTML = 'No PDF Base64 Data !';
      } else {
        downloadPDFBase64File(lastPDFBase64Data, "signed.pdf");
      }
    }
    else if(psVal === '1') {
      OpenNewMultiSignContractWebPage();
    }
    else {
      alert('Error !');
    } 
  }
}

function PushMultiSignWebPageToSignPad() {
  if(CurrentPushMode===4) {
    return;
  }
  CurrentPushMode = 4;
  LastSignMode = 2;

  document.getElementById("displayType").innerHTML = '正在推屏单页多签页面...';
  
  // push multiple sign webpage to signpad...
  var jsParamm =
  {
    "Command": CMDID_PUSH_WEBPAGE_TO_SIGNPAD,
    "Data": 
    {
      "type": PUSH_WEBPAGE_TYPE_MULTI_SIGN,
      "url": encodeURIComponent(domainNameUrl + '/MultiSignPage.html'),
    }
  };
  var strCmdJsonData = JSON.stringify(jsParamm);

  // send urlPushMultiSignWebPageToSignPad...
  var urlPushMultiSignWebPageToSignPad = strCmdJsonData;
  websocket.send(urlPushMultiSignWebPageToSignPad);
}

function downloadPDFBase64File(contentBase64, fileName) {
  const linkSource = `data:application/pdf;base64,${contentBase64}`;
  const downloadLink = document.createElement('a');
  document.body.appendChild(downloadLink);

  downloadLink.href = linkSource;
  downloadLink.target = '_self';
  downloadLink.download = fileName;
  downloadLink.click(); 
}

function OpenNewContractWebPage() {
  if(contractWindowProxy) {
    contractWindowProxy.close()
    contractWindowProxy = null
  }

  contractWindowProxy = window.open('contract.html', "_blank");

  if(contractWindowProxy) { 
    PostSignImageDataToContractWebPage();
  }
}

function OpenNewMultiSignContractWebPage() {
  if(multiSignContractWindowProxy) {
    multiSignContractWindowProxy.close()
    multiSignContractWindowProxy = null
  }

  multiSignContractWindowProxy = window.open('multisign_contract.html', "_blank");

  if(multiSignContractWindowProxy) {
    PostSignImageDataToMultiSignContractWebPage();
  }
}

function PostSignImageDataToContractWebPage() {
  var timeId = setTimeout(function() {
    clearTimeout(timeId);
    contractWindowProxy.postMessage(lastSignImageBase64Data, '*');
  }, 200);
}

function PostSignImageDataToMultiSignContractWebPage() {
  var timeId = setTimeout(function() {
    clearTimeout(timeId);
    
    var msgData = null;

    if(lastSignImageBase64Data) {
      msgData = '<1>' + lastSignImageBase64Data;
      multiSignContractWindowProxy.postMessage(msgData, "*"); 
    }

    if(lastSignImageBase64Data2) {
      msgData = '<2>' + lastSignImageBase64Data2;
      multiSignContractWindowProxy.postMessage(msgData, "*");
    }

    if(lastSignImageBase64Data3) {
      msgData = '<3>' + lastSignImageBase64Data3;
      multiSignContractWindowProxy.postMessage(msgData, "*");
    }
  }, 200);
}

function ClosePushContractWebPageToSignPad() {
  if(CurrentPushMode===0) {
    document.getElementById("displayType").innerHTML = '正在结束推屏空白合同页面...';

    // close push contract webpage to signpad...
    var jsParamm =
    {
      "Command": CMDID_CLOSE_PUSH_WEBPAGE_TYPE_SIGN,
      "Data": null
    };
    var strCmdJsonData = JSON.stringify(jsParamm);

    // send urlClosePushWebPageTypeSign...
    var urlClosePushWebPageTypeSign = strCmdJsonData;
    websocket.send(urlClosePushWebPageTypeSign);
  }
}

function ClosePushMultiSignWebPageToSignPad() {
  if(CurrentPushMode===4) {
    document.getElementById("displayType").innerHTML = '正在结束推屏单页多签页面...';

    // close push contract webpage to signpad...
    var jsParamm =
    {
      "Command": CMDID_CLOSE_PUSH_WEBPAGE_TYPE_MULTI_SIGN,
      "Data": null
    };
    var strCmdJsonData = JSON.stringify(jsParamm);

    // send urlClosePushWebPageTypeMultiSign...
    var urlClosePushWebPageTypeMultiSign = strCmdJsonData;
    websocket.send(urlClosePushWebPageTypeMultiSign);
  }
}

// send message from console webpage into signpad webpage...
function SendMsgFromConsoleWebPage() {
  var jsParamm =
  {
    "Command": CMDID_SEND_MSG_FROM_CONSOLE_WEBPAGE,
    "Data": "123"
  };
  var strCmdJsonData = JSON.stringify(jsParamm);

  // send urlSendMsgFromConsoleWebPage to signpad webpage...
  var urlSendMsgFromConsoleWebPage = strCmdJsonData;
  websocket.send(urlSendMsgFromConsoleWebPage);
}
