'use strict';

// API Url
var websocket = null;
var wsUrl = 'ws://localhost:8089';
var apiUrl = wsUrl + '/PPSignSDK/';

// initialize device web api
var initUrl_L398 = apiUrl + 'InitialDevice?id=2&width=1740&height=825';
var initUrl_L500 = apiUrl + 'InitialDevice?id=5&width=1740&height=825';
var initUrl_L501F = apiUrl + 'InitialDevice?id=7&width=1740&height=825';
var initUrl_LC700 = apiUrl + 'InitialDevice?id=3&width=1740&height=825';
var initUrl_E640 = apiUrl + 'InitialDevice?id=4&width=1740&height=825';

// uninitialize device web api
var uninitUrl_L398 = apiUrl + 'UninitialDevice?id=2';
var uninitUrl_L500 = apiUrl + 'UninitialDevice?id=5';
var uninitUrl_L501F = apiUrl + 'UninitialDevice?id=7';
var uninitUrl_LC700 = apiUrl + 'UninitialDevice?id=3';
var uninitUrl_E640 = apiUrl + 'UninitialDevice?id=4';

// get ink web api
var getInkUrl = apiUrl + 'WPSGetInks';
// clear ink api
var clrInkUrl = apiUrl + 'Clear';
// set pen width api
var penwidthUrl = apiUrl + 'SetPenWidth?Width=';
// get GetDeviceConfirmOrCancelKeyStatus api
var confirmStatusUrl = apiUrl + 'GetDeviceConfirmOrCancelKeyStatus';
// get Settings api
var getSettingsUrl = apiUrl + 'GetWPSSettings?id=1';
// update Settings api
var updateSettingsUrl = apiUrl + 'UpdateWPSSettings?id=1';
// Sign Confirmed api
var SignConfirmedUrl = apiUrl + 'WPSSignConfirmed?id=1';

// =========================================
// global variables definition...
var context;

var isPolling = false;
var LastSignatureBase64Data;
var bInitWebSocket = false;
var currentConnectedSignPadID = 1;
var bWebSocketClosed = false;
// =========================================

function onbuttonclick(idStr)
{
    switch(idStr)
    {
        case "btnConfirm": {
            isPolling = false;
            updateSettingsInfo()
            break
        }

        case "btnClear": {
            clearInk();
            break
        }
    }
}

function onPenWidthChange()
{
    var pwSelect = document.getElementById("penWidth");
    var pwSelectedPenWidth = pwSelect.value * 2 - 1;

    websocket.send(penwidthUrl + pwSelectedPenWidth);
}

function sentOutSignImage(strSignImagePath)
{
    var bAutoFit = document.querySelector("#autoFit").checked;
    wps.WpsApplication().ScreenUpdating = false;
    var select =  wps.WpsApplication().Selection;
    var fontSize = select.Font.Size;
    var ilShape = select.InlineShapes.AddPicture(strSignImagePath, false, true, select.Range);
    var ilShapeWidth = ilShape.Width;
    var ilShapeHeight = ilShape.Height;

    if(bAutoFit) {
        var ilShapeNewHeight = fontSize;
        var ilShapeNewWidth = ilShapeNewHeight * ilShapeWidth / ilShapeHeight;
        ilShape.Width = ilShapeNewWidth;
        ilShape.Height = ilShapeNewHeight;
    } else {
    }

    var shape = ilShape.ConvertToShape();
    var shapeWidth = shape.Width;
    var shapeHeight = shape.Height;

    if(bAutoFit) {
        var fltLineHeight = 0.0;
        var fltLineWidth = 0.0;

        if(fontSize < 4.0) {
            fltLineHeight = 4.0;
        } else {
            fltLineHeight = fontSize + 3.0;
        }

        fltLineWidth = fltLineHeight * ilShapeWidth / ilShapeHeight;
        shape.Width = fltLineWidth;
        shape.Height = fltLineHeight;
    } else {
        const MAX_SHAPE_OBJ_WIDTH = 360.0;
        const MAX_SHAPE_OBJ_HEIGHT = 360.0;

        var fltNewShapeHeight = ilShapeHeight;
        var fltNewShapeWidth = ilShapeWidth;

        if(ilShapeWidth > ilShapeHeight) {
            if(ilShapeWidth > MAX_SHAPE_OBJ_WIDTH) {
                fltNewShapeWidth = MAX_SHAPE_OBJ_WIDTH;
                fltNewShapeHeight = ilShapeHeight * fltNewShapeWidth / ilShapeWidth;
            }
        } else {
            if(ilShapeHeight > MAX_SHAPE_OBJ_HEIGHT) {
                fltNewShapeHeight = MAX_SHAPE_OBJ_HEIGHT;
                fltNewShapeWidth = ilShapeWidth * fltNewShapeHeight / ilShapeHeight;
            }
        }

        shape.Width = fltNewShapeWidth;
        shape.Height = fltNewShapeHeight;
    }
    wps.WpsApplication().ScreenUpdating = true;
}

window.onload = function ()
{
    var canvas = document.getElementById('ppCanvas');
    if (canvas.getContext) {
        context = canvas.getContext('2d');
    }

    window.addEventListener('blur', OnExitDialog)
    bInitWebSocket = true;
    initWebSocket();
}

function OnExitDialog(event)
{
    isPolling = false;

    window.opener = self
    window.close()
}

window.onbeforeunload = function (e)
{
    isPolling = false;

    if ( websocket && websocket.readyState == 1 ) {
        switch(currentConnectedSignPadID) {
            case 1:
                websocket.send(uninitUrl_L398);
                websocket.close();
                break;

            case 2:
                websocket.send(uninitUrl_L500);
                websocket.close();
                break;

            case 3:
                websocket.send(uninitUrl_L501F);
                websocket.close();
                break;

            case 4:
                websocket.send(uninitUrl_LC700);
                websocket.close();
                break;

            case 5:
                websocket.send(uninitUrl_E640);
                websocket.close();
                break;
        }
    }
}

// initialize Web Socket
function initWebSocket() {
    try {
        if ( websocket && websocket.readyState == 1 )
            websocket.close();

        websocket = new WebSocket( wsUrl );
        websocket.onopen = function (evt) {
            // CONNECTED...
            bInitWebSocket = false;
            ShowStatusMsg('初始化【蒙恬电子签名板】...');

            // send initUrl_L398 to initial device...
            websocket.send(initUrl_L398);
        }
        websocket.onclose = function (evt) {
            // DISCONNECTED...
            if(bInitWebSocket) {
                bInitWebSocket = false;
                // alert('please run PPSignPadSDK_WSSvr first !');
                ShowStatusMsg('请首先到桌面执行【蒙恬电子签名板驱动程序】 !');
            }
        }
        websocket.onmessage = function (evt) {
            // message coming from local server...
            var dataInfos = JSON.parse(evt.data);
            processWebSocketResponse(dataInfos);
        }       
        websocket.onerror = function (evt) {
            // ERROR : value at evt.data !
//            alert('initWebSocket() error: ' + evt.data);
            ShowStatusMsg('initWebSocket() error: ' + evt.data);
        }
    }
    catch (exception) {
        // exception error !
        bInitWebSocket = false;
//        alert('initWebSocket() exception error: ' + exception);
        ShowStatusMsg('initWebSocket() exception error: ' + exception);
    }
}

function processWebSocketResponse(wsResponse) {
    var APIName = wsResponse.API;
    var Result = wsResponse.Result;

    if(APIName == 'InitialDevice') {
        if(Result == '1') {
            isPolling = true;

            getSettingsInfo();
            getInk();
            getStatus();

            var ctrlPanel = document.getElementById("controlPanel");
            ctrlPanel.disabled = false;
            ShowStatusMsg('请开始签名...');
        } else {
            ++currentConnectedSignPadID;
            if(currentConnectedSignPadID == 2) {
                // send initUrl_L500 to initial device...
                websocket.send(initUrl_L500);
            } else if (currentConnectedSignPadID == 3) {
                // send initUrl_L501F to initial device...
                websocket.send(initUrl_L501F);
            } else if (currentConnectedSignPadID == 4) {
                // send initUrl_LC700 to initial device...
                websocket.send(initUrl_LC700);
            } else if (currentConnectedSignPadID == 5) {
                // send initUrl_E640 to initial device...
                websocket.send(initUrl_E640);
            } else {
//            alert('No device!');
                ShowStatusMsg('找不到【蒙恬电子签名板】 !');
            }
        }
    }
    else if(APIName == 'UninitialDevice') {
        if(Result == '1') {
            if ( websocket && websocket.readyState == 1 ) {
            }
        }
    }
    else if(APIName == 'WPSGetInks') {
        if(Boolean(Result)) {
            var dataInfos = JSON.parse(Result);
            var inkData = dataInfos[0];

            if (inkData.EventType == '0') {
                drawImage(inkData.Image);
                LastSignatureBase64Data = inkData.Image;
            }
        }
    
        if(isPolling)
            getInk();
        else {}
    }
    else if(APIName == 'GetDeviceConfirmOrCancelKeyStatus') {
        if (Result == '1') {
            isPolling = false;
            updateSettingsInfo()
        } else if (Result == '0') {
            clearInk();
        }

        if(isPolling)
            getStatus();
        else {}
    }
    else if(APIName == 'Clear') {
        var canvas = document.getElementById('ppCanvas');
        context.clearRect(0, 0, canvas.width, canvas.height);
    }
    else if(APIName == 'SetPenWidth') {
        clearInk();
    }
    else if(APIName == 'GetWPSSettings') {
        if(Boolean(Result)) {
            var settingsData = JSON.parse(Result);
            updateUISettingsInfo(settingsData);
            onPenWidthChange();
        }
    }
    else if(APIName == 'UpdateWPSSettings') {
        signConfirmed()
    }
    else if(APIName == 'WPSSignConfirmed') {
        OnExitDialog(null);

        if(Boolean(parseInt(Result))) {
            // error !!!
        } else {
            sentOutSignImage(Result);
        }
    }

}

function ShowStatusMsg(msg)
{
    var status = document.getElementById("status");
    status.value = msg;
}

function getStatus() {
    var timeId = setTimeout(function () {
        clearTimeout(timeId);

        if (isPolling) {
            // send confirmStatusUrl to start get device confirm or cancel Key status...
            websocket.send(confirmStatusUrl);
        }
    }, 100);
}

function getInk() {
    var timeId = setTimeout(function () {
        clearTimeout(timeId);

        if (isPolling) {
            // send getInkUrl to start get ink data...
            websocket.send(getInkUrl);
        }
    }, 5);
}

function drawImage(base64) {
    var dataUrl = 'data:image/jpg;base64,';
    dataUrl = dataUrl + base64;

    var img = new Image();

    img.addEventListener('load', function () {
        var canvas = document.getElementById('ppCanvas');
        context.drawImage(this, 0, 0, canvas.width, canvas.height);
    }, false);

    img.src = dataUrl;
}

function clearInk() {
    // send clrInkUrl to clear device...
    websocket.send(clrInkUrl);
}

function getSettingsInfo() {
    // send getSettingsUrl to get Settings info...
    websocket.send(getSettingsUrl);
}

function updateUISettingsInfo(settingsData) {
    var bDateTime = settingsData.EnableDateTime;
    var bAutoFit = settingsData.EnableAutoFit;
    var nCurrentPenWidth = settingsData.CurrentPenWidth;
    var strName = settingsData.Name;

    var dateTime = document.getElementById("dateTime");
    if(bDateTime == '1')
        dateTime.checked = true;
    else
        dateTime.checked = false;

    var autoFit = document.getElementById("autoFit");
    if(bAutoFit == '1')
        autoFit.checked = true;
    else
        autoFit.checked = false;

    var penWidth = document.getElementById("penWidth");
    penWidth.selectedIndex = nCurrentPenWidth - 1;

    var inputName = document.getElementById("inputName");
    inputName.value = strName;
}

function updateSettingsInfo() {
    isPolling = false;
    window.resizeTo(1, 1);

    var bDateTime = document.querySelector("#dateTime").checked;
    var bAutoFit = document.querySelector("#autoFit").checked;
    var pwCurrentSelectedPenWidth = document.getElementById("penWidth").value;
    var inputName = document.getElementById("inputName").value;

    // send updateSettingsUrl to update Settings info...
    var targetUpdateSettingsUrl = updateSettingsUrl + "&dt=" + Number(bDateTime) + "&af=" + Number(bAutoFit) + "&pw=" + pwCurrentSelectedPenWidth + "&name=" + inputName;
    websocket.send(targetUpdateSettingsUrl);
}

function signConfirmed() {
    // send SignConfirmedUrl to do sign confirmed action...
    websocket.send(SignConfirmedUrl);
}
