//
//  PPIDCardDetectStatus.h
//  PPIDCardSDK
//

#ifndef PPIDCardDetectStatus_h
#define PPIDCardDetectStatus_h

////////////////////////////////////////////////////////////////////////////////////////////////////

/// 偵測狀態
typedef NS_OPTIONS(NSInteger, PPIDCardDetectStatus)
{
    PPIDCardDetectStatus_None = 0,

    /// 1 : 開始偵測
    PPIDCardDetectStatus_Start,

    /// 2 : 請將手機轉至橫向
    PPIDCardDetectStatus_RotateToLandscape,

    /// 3 : 沒有授權
    PPIDCardDetectStatus_NoLicense,
    
    /// 4 : 偵測不到四邊
    PPIDCardDetectStatus_FailedToDetectEdge,
    
    /// 5 : 影像太小
    PPIDCardDetectStatus_ImageTooSmall,
    
    /// 6 : 影像校正失敗
    PPIDCardDetectStatus_FailedToAdjustImage,
    
    /// 7 : 人臉偵測失敗
    PPIDCardDetectStatus_FailedToDetectFace,
    
    /// 8 : 影像模糊 (有反光模糊偵測版本才會回傳)
    PPIDCardDetectStatus_ImageBlur,
    
    /// 9 : 影像反光 (有反光模糊偵測版本才會回傳)
    PPIDCardDetectStatus_ImageReflection,
    
    /// 10 : 請翻到正面 (有正反面偵測版本才會回傳)
    PPIDCardDetectStatus_TurnCardFront,
    
    /// 11 : 請翻到反面 (有正反面偵測版本才會回傳)
    PPIDCardDetectStatus_TurnCardBack,
    
    /// 12 : 辨識失敗
    PPIDCardDetectStatus_FailedToRecognize,
    
    /// 13 : 準備拍照
    PPIDCardDetectStatus_ReadyToCapture,
};



#endif /* PPIDCardDetectStatus_h */
