//
//  PPIDCardViewController.h
//  PPIDCardSDK
//

#import <UIKit/UIKit.h>
#import "PPIDCardAppearanceModel.h"
#import "PPIDCardResultModel.h"


@interface PPIDCardViewController : UIViewController

/// 身份證辨識及結果顯示流程介面
/// @param signature 蒙恬簽章
/// @param completion 辨識結果。frontSideResult為正面資料，backSideResult為背面資料。
+ (UINavigationController *)navigationControllerWithSignature:(NSString *)signature completion:(void (^)(PPIDCardResultModel *frontSideResult, PPIDCardResultModel *backSideResult))completion;

@end
