#include <dlfcn.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define WINAPI
#define NO_CANDIDATE 10

#include "ink.c"

#define	FALSE	0
#define TRUE	1
#define WORD	unsigned short
#define DWORD	unsigned int
typedef struct tagPointType{
  short x;
  short y;
} POINT_TYPE, *LPPOINT_TYPE;

typedef	int (*LPHWRConnect)(char* aHwrPath, int aAiEnable, char* aAiPath, int aAiMultiEnable, char* aAiMultiPath, int aDictEnable, char* aDictPath, int aLearnEnable, char* aLearnPath);
typedef	int (*LPHWRSetType)(int aType);
typedef	int (*LPHWRSetCandidateNum)(short aNumber);
typedef	int (*LPHWRRecognize)(short* aTrace, unsigned short* aResult);
typedef	int (*LPHWRSetBox)(int aLeft, int aTop, int aRight, int aBottom);
typedef	void (*LPHWRDisconnect)(void);
typedef	void (*LPHWRSetResolution)(int aWidth, int aHeight);
typedef	void (*LPHWRSetCountry)(int aCountry);
typedef	int (*LPHWRProcessStrokes)(short* aTrace);
typedef	int (*LPHWRFinalProcess)(unsigned short* aResult);
typedef	int (*LPHWRProcessStrokesForAlpha)(short* aTrace, unsigned short* aResult);
typedef	int (*LPHWRFinalProcessForAlpha)(unsigned short* aResult);
typedef	int (*LPHWRConvertUTF16_2_UTF32)(unsigned short* autf16_str, unsigned int* autf32_str, int no_entries);
typedef	int (*LPHWRConvertUTF32_2_UTF16)(unsigned int* autf32_str, unsigned short* autf16_str, int no_entries);
typedef	int (*LPHWRUTF32_2_Surrogate)(unsigned int* au32_code, unsigned short* au16_code_string, int u32_count);
typedef	int (*LPHWRSurrogate_2_UTF32)(unsigned short* au16_code_string, unsigned int* au32_code,int u32_count);

POINT_TYPE RawStroke[1024];
POINT_TYPE BackRawStroke[1024];
unsigned short code_array[100];
unsigned short phrase_array[100];

LPHWRConnect HWRConnect;
LPHWRSetType HWRSetType;
LPHWRSetBox HWRSetBox;
LPHWRSetCandidateNum HWRSetCandidateNum;
LPHWRRecognize HWRRecognize;
LPHWRDisconnect HWRDisconnect;

int aAiEnable = FALSE;
int aAiMultiEnable = FALSE;
int aDictEnable = FALSE;
int aLearnEnable = FALSE;
char *aHwrDBPath = NULL;
char *aAiPath = NULL;
char *aAiMultiPath = NULL;
char *aDictPath = NULL;
char *aLearnPath = NULL;
int main(int argc, char** argv)
{
  short i,j,no_point,flag,no_cand,k, no_phrase;
  short *ptr_ink,*back_ptr_ink;
  unsigned short code;
  short char_count,iresult;
  unsigned long value;
  int RamSize;

  int iResult;
  void *hWrapper;

  if (argc < 2) {
	fprintf(stderr, "usage: %s <DBPath>", argv[0]);
	return -1;
  }
  hWrapper=dlopen("./libPPHwrsdkClient.so",RTLD_NOW);
  if(!hWrapper){
    fputs(dlerror(),stderr);
    return -2;
  }

  HWRConnect=(LPHWRConnect)dlsym(hWrapper,"HWRConnect");
  HWRSetType=(LPHWRSetType)dlsym(hWrapper,"HWRSetType");
  HWRSetBox=(LPHWRSetBox)dlsym(hWrapper,"HWRSetBox");
  HWRSetCandidateNum=(LPHWRSetCandidateNum)dlsym(hWrapper,"HWRSetCandidateNum");
  HWRRecognize=(LPHWRRecognize)dlsym(hWrapper,"HWRRecognize");
  HWRDisconnect=(LPHWRDisconnect)dlsym(hWrapper,"HWRDisconnect");

  if (   HWRConnect == NULL
      || HWRSetType == NULL
      || HWRSetBox == NULL
      || HWRSetCandidateNum == NULL
      || HWRRecognize == NULL
	  || HWRDisconnect == NULL
     )
  {
     fprintf(stderr, "Hwre Library miss function(s).\n");
     dlclose(hWrapper);
     return -3;
  }
  aHwrDBPath = argv[1];
  fprintf(stderr, "argc = %d argv[1] = %s\n", argc, argv[1]);
  iResult=(*HWRConnect)(aHwrDBPath,
						aAiEnable, aAiPath,
						aAiMultiEnable, aAiMultiPath,
						aDictEnable, aDictPath,
						aLearnEnable, aLearnPath);
  fprintf(stderr,"Initialize iResult = %d\n", iResult);
  if (iResult != 0) {
     dlclose(hWrapper);
     fprintf(stderr, "initialize HWRE failed\n");
     return -4;
  }

  i=0;
  char_count=0;

  // Max returned candidate count. 1 ~ 10
  iResult = (*HWRSetCandidateNum)(NO_CANDIDATE);
  // Recognize all Characters, but return only Traditional Chinese Candidates
  iResult = (*HWRSetType)(0x007FF);
  // Set criteria to judge for Upper or Lower Alphabets(such as: "Cc", "Oo", "Ss", "Uu", "Vv", "Xx", "Zz")
  iResult = (*HWRSetBox)(0, 0, 120, 120);

  ptr_ink=(short *)ink_data;
  flag=1;
  while(flag){
    back_ptr_ink=ptr_ink;
    no_point=*ptr_ink++;
    if(no_point<=0)break;
    fprintf(stderr, "%3d, I: %d I", char_count, no_point);
    for(i=0;i<no_point;i++){
      RawStroke[i].x=*ptr_ink++;
      RawStroke[i].y=*ptr_ink++;
    }
    RawStroke[i-1].y=-1;
    RawStroke[i].x=RawStroke[i].y=-2;

    memmove(BackRawStroke,RawStroke,(i+1)*sizeof(POINT_TYPE));

    iResult =(*HWRRecognize)((WORD *)RawStroke, (WORD *)code_array);
    no_cand = 0;
    while(code_array[no_cand*2]) no_cand++;

    fprintf(stderr, "%3d, iResult = %d, no_cand = %d\n", char_count, iResult, no_cand);
    for(k=0;k<no_cand;k++){
      fprintf(stderr,"<%04x, %4d>",code_array[k*2], code_array[k*2+1]);
    }
    fprintf(stderr,"\n");

    if(no_cand!=*ptr_ink){
       // fprintf(stderr,"Cand Count Mismatch : new=%d old=%d\n",
       //         no_cand,*ptr_ink);
    }
    char_count++;
    no_cand=*ptr_ink++;
    ptr_ink += no_cand;
  }
skip:;
  printf("finished %d\n",char_count);

  (*HWRDisconnect)();
  dlclose(hWrapper);

  return 0;
}

